#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
import commands
import shutil
import tv2avi
import os
import re
import os.path
import string
import base64
import time
import recdblist
import configreader
import status

def ts2mp4(pin, pout, opt):
    dir=os.path.split(pout)[0]
    title=os.path.split(pout)[1]
    title=os.path.splitext(title)[0]
    tpraw=os.path.join(dir, title+".264")
    tpmp4=os.path.join(dir, title+".mp4")
    if os.path.isfile(pin) and os.path.getsize(pin)>10*1000:
        tv2avi.ts2raw(pin, tpraw, opt)
        time.sleep(10)
        if os.path.isfile(tpraw) and os.path.getsize(tpraw)>10*1000:
            raw2mp4(tpraw, tpmp4, opt)
        time.sleep(10)
        if os.path.exists(tpraw):
            os.remove(tpraw)
def raw2mp4(pin,pout,opt):
    dir=os.path.split(pout)[0]
    title=os.path.split(pout)[1]
    title=os.path.splitext(title)[0]
    duration="-fps 29.970030 "
    ffmpeg=configreader.getpath("ffmpeg")
    isdualaac=0
    ispentaaudio=0
    if re.search("a",opt):
        duration="-fps 23.976023 "
    elif re.search("v",opt):
        duration="-fps 23.976023 "
    if re.search("d",opt):
        isdualaac=1
        duration="-fps 29.970030 "##ffmpegが24fpsに対応していないための措置
    elif re.search("5",opt):
        ispentaaudio=1
        duration="-fps 29.970030 "##ffmpegが24fpsに対応していないための措置
    exe = configreader.getpath("mp4box")
    txt=""
    os.environ['LANG']="ja_JP.UTF-8"
    if isdualaac==1:
        wineexe=configreader.getpath("wine")
        pincap=pin.replace(".264",".srt")
        try:
            cap2ass=configreader.getpath("caption2ass")
        except:
            cap2ass=""
        pints=pin.replace(".264",".ts")
        paac1=pin.replace(".264","_1.aac")
        paac2=pin.replace(".264","_2.aac")
        recdblist.printutf8(paac1)
        if not os.path.exists(paac1):
            paac1=pin.replace(".264","_1.mp3")
        if not os.path.exists(paac2):
            paac2=pin.replace(".264","_2.mp3")
        e0=wineexe+u" "+cap2ass+u" -format srt \"Z:\\"+pints+"\" \"Z:\\"+pincap+"\""
        e1=exe +u" "+duration+" -add \""+pin+"\" -new \""+pout+"\""
        e1a1=exe +u" -add \""+paac1+"\" \""+pout+"\""
        e1a2=exe +u" -add \""+paac2+"\" \""+pout+"\""
        e1s=exe +u" -add \""+pincap+"\" \""+pout+"\""
        if os.path.isfile(cap2ass):
            txt=txt+execcomd(e0)
        execmp4box(pin, pout, e1)
        addmp4(paac1, pout, e1a1)
        addmp4(paac2, pout, e1a2)
        if os.path.exists(pincap) and (os.path.getsize(pincap)>1000):
            addmp4(pincap, pout, e1s)
    elif ispentaaudio==1:
        wineexe=configreader.getpath("wine")
        pincap=pin.replace(".264",".srt")
        try:
            cap2ass=configreader.getpath("caption2ass")
        except:
            cap2ass=""
        pints=pin.replace(".264",".ts")
        paac1=pin.replace(".264","_1.aac")
        paac2=pin.replace(".264","_2.aac")
        recdblist.printutf8(paac1)
        if not os.path.exists(paac1):
            paac1=pin.replace(".264","_1.mp3")
        if not os.path.exists(paac2):
            paac2=pin.replace(".264","_2.mp3")
        e0=wineexe+u" "+cap2ass+u" -format srt \"Z:\\"+pints+"\" \"Z:\\"+pincap+"\""
        e1=exe +u" "+duration+" -add \""+pin+"\" -new \""+pout+"\""
        e1a1=exe +u" -add \""+paac1+"\" \""+pout+"\""
        e1a2=exe +u" -add \""+paac2+"\" \""+pout+"\""
        e1s=exe +u" -add \""+pincap+"\" \""+pout+"\""
        if os.path.isfile(cap2ass):
            txt=txt+execcomd(e0)
        execmp4box(pin, pout, e1)
        addmp4(paac1, pout, e1a1)
        addmp4(paac2, pout, e1a2)
        if os.path.exists(pincap) and (os.path.getsize(pincap)>1000):
            addmp4(pincap, pout, e1s)
    else:
        wineexe=configreader.getpath("wine")
        pincap=pin.replace(".264",".srt")
        try:
            cap2ass=configreader.getpath("caption2ass")
        except:
            cap2ass=""
        pints=pin.replace(".264",".ts")
        pinaac=pin.replace(".264",".aac")
        e0=wineexe+u" "+cap2ass+u" -format srt \"Z:\\"+pints+"\" \"Z:\\"+pincap+"\""
        e1=ffmpeg+" -i \""+pints+"\" -vn -f aac -acodec copy \""+pinaac+"\""
        e2=exe +u" "+duration+" -add \""+pin+"\" -new \""+pout+"\""
        e2a=exe +u" -add \""+pinaac+"\" \""+pout+"\""
        e2s=exe +u" -add \""+pincap+"\" \""+pout+"\""
        if os.path.isfile(cap2ass):
            txt=txt+execcomd(e0)
        txttt=execcomd(e1)
        recdblist.addlog(pin, txttt, "get_aac")
        execmp4box(pin, pout, e2)
        addmp4(pinaac, pout, e2a)
        if os.path.exists(pincap) and (os.path.getsize(pincap)>1000):
            addmp4(pincap, pout, e2s)
    recdblist.addlog(pout, txt, "mp4box-log")
    if status.getSettings_auto_del_tmp()==1:
        if os.path.exists(pout):
            if re.search(opt,"MW8") or re.search(opt,"MW9"):
                if os.path.getsize(pout)>50*1000*1000:
                    deltitle(dir,title)
            elif re.search(opt,"8") or re.search(opt,"9"):
                ""
            else:
                if os.path.getsize(pout)>100*1000*1000:
                    deltitle(dir,title)
def mkv2mp4(pin,pout):
    exeb = configreader.getpath(u"mkvextract")
    exe = configreader.getpath(u"mp4Box")
    #dtsedit=configreader.getpath("DtsEdit")
    wineexe=configreader.getpath("wine")
    dir=os.path.split(pin)[0]
    title=os.path.split(pin)[1]
    title=os.path.splitext(title)[0]
    etitle=base64.b16encode(title.encode('utf-8'))
    audiopath=os.path.join(dir,etitle+u"_audio.aac")
    videopath=os.path.join(dir,etitle+u"_video.264")
    timecodepath=os.path.join(dir,etitle+u"_1_timecode.txt")
    tmpmp4=os.path.join(dir,etitle+u".tmp.mp4")
    exe0=exeb+u" tracks \'"+pin+u"\' 1:\'"+videopath+u"\' 2:\'"+audiopath+u"\'"
    exe1=exeb+u" timecodes_v2 \'"+pin+"\' 1:\'"+timecodepath+"\'"
    exe2=exe+u" -fps 29.970030 -add \'"+videopath+u"\' -add \'"+audiopath+u"\' -new \'"+tmpmp4+u"\'"
    exe3=wineexe+u" "+dtsedit+u" -tc \'Z:\\"+timecodepath+u"\' \'Z:\\"+tmpmp4+u"\' -o \'Z:\\"+pout+u"\'"
    os.environ['LANG']="ja_JP.UTF-8"
    txt=""
    try:
        txt=txt+execcomd(exe0)+"\n"
        txt=txt+execcomd(exe1)+"\n"
        txt=txt+execcomd(exe2)+"\n"
        txt=txt+execcomd(exe3)+"\n"
    except:
        ""
    recdblist.addlog(pin, txt, "MKV2MP4-log")
    txt = "\n####MKV2MP4-log####\n"+txt
    time.sleep(10)
    if status.getSettings_auto_del_tmp()==1:
        if os.path.exists(pout):
            if os.path.getsize(pout)>100*1000*1000:
                deltitle(dir,title)
def execmp4box(pin,pout,cmd):
    title=os.path.splitext(os.path.split(pin)[1])[0]
    ptin=os.path.join(os.path.dirname(pin),base64.b16encode(title.encode('utf-8'))+".264")
    recdblist.printutf8(ptin)
    shutil.move(pin,ptin)
    time.sleep(10)
    ptout=os.path.join(os.path.dirname(pout),base64.b16encode(title.encode('utf-8'))+".mp4")
    cmdn=string.replace(cmd,pin,ptin)
    cmdn=string.replace(cmdn,pout,ptout)
    recdblist.printutf8(cmdn)
    txt=""
    try:
        txt=execcomd(cmdn)
    except Exception, inst:
        txt= "error occures in execmp4box\n"
        txt=txt+ str(type(inst))+"\n"
        txt=txt+str(inst)
    recdblist.addlog(pin, txt, "MP4Box-log")
    time.sleep(5)
    shutil.move(ptin,pin)
    shutil.move(ptout,pout)
    time.sleep(5)
def addmp4(padd,pout,cmd):#without video
    title=os.path.splitext(os.path.split(padd)[1])[0]
    ext=os.path.splitext(os.path.split(padd)[1])[1]
    ptadd=os.path.join(os.path.dirname(padd),base64.b16encode(title.encode('utf-8'))+ext)
    ptoutb=os.path.join(os.path.dirname(pout),base64.b16encode(title.encode('utf-8'))+"_b.mp4")
    ptout=os.path.join(os.path.dirname(pout),base64.b16encode(title.encode('utf-8'))+".mp4")
    shutil.move(padd,ptadd)
    if os.path.isfile(pout):
        shutil.move(pout,ptoutb)
    time.sleep(5)
    cmdn=string.replace(cmd,padd,ptadd)
    cmdn=string.replace(cmdn,u"-out \""+pout,u"-add \""+ptoutb+"\" -new \""+ptout)
    cmdn=string.replace(cmdn,u"\""+pout,u"-add \""+ptoutb+"\" -new \""+ptout)
    cmdn=string.replace(cmdn,pout,ptout)
    recdblist.printutf8(cmdn)
    txt=""
    try:
        txt=execcomd(cmdn)
    except Exception, inst:
        txt= "error occures in addmp4\n"
        txt=txt+ str(type(inst))+"\n"
        txt=txt+str(inst)
    recdblist.addlog(pout, txt, "MP4Box-log-add")
    time.sleep(5)
    os.remove(ptoutb)
    shutil.move(ptadd,padd)
    shutil.move(ptout,pout)
    time.sleep(5)
def execcomd(cmd):
    txt=""
    try:
        txt=u"Cmd : "+cmd+"\n"
        txt2=commands.getoutput(cmd.encode('utf-8'))
        txt=txt+unicode(txt2,"utf-8")+"\n"
    except:
        ""
    return txt

def deltitle(path,title):
    dp=[]
    dp.append(os.path.join(path,title+".avi"))
    dp.append(os.path.join(path,title+".264"))
    dp.append(os.path.join(path,title+".120.avi"))
    dp.append(os.path.join(path,title+".noodml.avi"))
    dp.append(os.path.join(path,title+".aac"))
    dp.append(os.path.join(path,title+".m2v"))
    dp.append(os.path.join(path,title+"_1.aac"))
    dp.append(os.path.join(path,title+"_2.aac"))
    dp.append(os.path.join(path,title+"_1.mp3"))
    dp.append(os.path.join(path,title+"_2.mp3"))
    dp.append(os.path.join(path,title+".srt"))
    if configreader.getenv("remove_ts")=="1":
        dp.append(os.path.join(path,title+".ts"))
    if os.path.exists(os.path.join(path,title+".ts"))and os.path.exists(os.path.join(path,title+".ts.b25")):
        if os.path.getsize(os.path.join(path,title+".ts"))*10>os.path.getsize(os.path.join(path,title+".ts.b25")):
            if os.path.getsize(os.path.join(path,title+".ts"))>1000*1000*100:
                dp.append(os.path.join(path,title+".ts.b25"))
    if os.path.exists(os.path.join(path,title+".mp4")):
        if os.path.getsize(os.path.join(path,title+".mp4"))>1000*1000*10:
            for ip in dp:
                try:
                    os.remove(ip)
                except:
                    ""
